/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.portal.ui.dispatch.actionControllers;

import com.aptana.configurations.processor.ConfigurationStatus;
import com.aptana.core.IFilter;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.jetty.util.epl.ajax.JSON;
import com.aptana.portal.ui.PortalUIPlugin;
import com.aptana.portal.ui.dispatch.IBrowserNotificationConstants;
import com.aptana.portal.ui.dispatch.actionControllers.AbstractActionController;
import com.aptana.portal.ui.dispatch.actionControllers.ControllerAction;
import com.aptana.theme.IThemeManager;
import com.aptana.theme.Theme;
import com.aptana.theme.ThemePlugin;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Set;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.css.swt.theme.ITheme;
import org.eclipse.e4.ui.css.swt.theme.IThemeEngine;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThemeActionController
extends AbstractActionController {
    private static final String UNKNOWN = "Unknown";
    private IThemeManager themeManager = ThemePlugin.getDefault().getThemeManager();

    @ControllerAction
    public Object getThemes() {
        Set themeNames = this.themeManager.getThemeNames();
        return JSON.toString((Object[])themeNames.toArray(new String[themeNames.size()]));
    }

    @ControllerAction
    public Object getActiveTheme() {
        Theme currentTheme = this.themeManager.getCurrentTheme();
        return JSON.toString((Object)(currentTheme != null ? currentTheme.getName() : UNKNOWN));
    }

    @ControllerAction
    public Object setActiveTheme(Object attributes) {
        final String themeName = this.getThemeName(attributes);
        if (!StringUtil.isEmpty((String)themeName)) {
            Theme theme = this.themeManager.getTheme(themeName);
            this.themeManager.setCurrentTheme(theme);
            IWorkbench workbench = PlatformUI.getWorkbench();
            MApplication application = (MApplication)workbench.getService(MApplication.class);
            IEclipseContext context = application.getContext();
            IThemeEngine e4ThemeEngine = (IThemeEngine)context.get(IThemeEngine.class);
            ITheme selection = (ITheme)CollectionsUtil.find((Collection)e4ThemeEngine.getThemes(), (IFilter)new IFilter<ITheme>(){

                public boolean include(ITheme item) {
                    return themeName.equals(item.getLabel());
                }
            });
            if (selection != null) {
                e4ThemeEngine.setTheme(selection, true);
            }
            return IBrowserNotificationConstants.JSON_OK;
        }
        return IBrowserNotificationConstants.JSON_ERROR;
    }

    public void configurationStateChanged(ConfigurationStatus status, Set<String> attributesChanged) {
    }

    private String getThemeName(Object attributes) {
        if (attributes instanceof Object[]) {
            Object[] arr = (Object[])attributes;
            if (arr.length == 1 && arr[0] != null) {
                return (String)arr[0];
            }
            String message = MessageFormat.format("Wrong argument count passed to ThemeActionController::setActiveTheme. Expected 1 and got {0}", arr.length);
            IdeLog.logError((Plugin)PortalUIPlugin.getDefault(), (Throwable)new Exception(message));
        } else {
            String message = MessageFormat.format("Wrong argument type passed to ThemeActionController::setActiveTheme. Expected Object[] and got {0}", attributes == null ? "null" : attributes.getClass().getName());
            IdeLog.logError((Plugin)PortalUIPlugin.getDefault(), (Throwable)new Exception(message));
        }
        return null;
    }
}

